/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.util.TagUtil;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tools.client.WaypointCompassGetter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWaypointCompass
extends Item {
    public static final String TAG_POS = "pos";
    public static final String TAG_DIMENSION = "dimension";
    public static final String TAG_CHECK_BEACON = "check_beacon";

    public ItemWaypointCompass() {
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_185043_a(new ResourceLocation("angle"), new WaypointCompassGetter());
    }

    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || !stack.func_77942_o() || world.func_82737_E() % 160L != 20L) {
            return;
        }
        Integer dimension = ItemWaypointCompass.getDimension(stack);
        if (dimension != null) {
            WorldServer other;
            if (dimension.intValue() == world.field_73011_w.getDimension()) {
                this.checkPos(stack, world, ItemWaypointCompass.getPos(stack));
            } else if (Config.waypointCompassCrossDimension && world.func_82737_E() % 320L == 20L && (other = DimensionManager.getWorld((int)dimension)) != null) {
                this.checkPos(stack, (World)other, ItemWaypointCompass.getPos(stack, dimension, other.field_73011_w.getDimension()));
            }
        }
    }

    private void checkPos(ItemStack stack, World world, BlockPos pos) {
        if (pos != null && world.func_175668_a(pos, false)) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityBeacon) {
                NBTTagCompound tags = stack.func_77978_p();
                if (((TileEntityBeacon)te).field_146015_k) {
                    tags.func_82580_o(TAG_CHECK_BEACON);
                } else if (tags.func_74767_n(TAG_CHECK_BEACON)) {
                    ItemWaypointCompass.clearNBT(stack);
                } else {
                    stack.func_77978_p().func_74757_a(TAG_CHECK_BEACON, true);
                }
            } else {
                ItemWaypointCompass.clearNBT(stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        DimensionType type = ItemWaypointCompass.getDimensionType(stack);
        if (type != null) {
            String dimension = type.func_186065_b().toLowerCase(Locale.US);
            String key = "dimension." + dimension.replace(' ', '_') + ".name";
            dimension = Util.canTranslate(key) ? Util.translate(key, new Object[0]) : ClientUtil.normalizeName(dimension);
            if (flag == ITooltipFlag.TooltipFlags.ADVANCED) {
                BlockPos pos;
                dimension = dimension + String.format(" (%d)", ItemWaypointCompass.getDimension(stack));
                if (Config.waypointCompassAdvTooltip && !Minecraft.func_71410_x().func_189648_am() && (pos = ItemWaypointCompass.getPos(stack)) != null) {
                    dimension = Util.translateFormatted(this.func_77658_a() + ".pos.tooltip", dimension, pos.func_177958_n(), pos.func_177952_p());
                }
            }
            tooltip.add(dimension);
        } else if (Config.craftWaypointCompass) {
            tooltip.add(TextFormatting.ITALIC + Util.translate(this.func_77658_a() + ".blank.tooltip", new Object[0]));
        } else {
            tooltip.add(TextFormatting.ITALIC + Util.translateFormatted(this.func_77658_a() + ".vanilla.tooltip", Util.translate(Items.field_151111_aL.func_77658_a() + ".name", new Object[0])));
        }
    }

    @Nullable
    public static Integer getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tags = stack.func_77978_p();
        return tags.func_150297_b(TAG_DIMENSION, 99) ? Integer.valueOf(tags.func_74762_e(TAG_DIMENSION)) : null;
    }

    @Nullable
    public static DimensionType getDimensionType(ItemStack stack) {
        Integer dimension = ItemWaypointCompass.getDimension(stack);
        if (dimension != null) {
            try {
                return DimensionManager.getProviderType((int)dimension);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static BlockPos getPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return TagUtil.readPos(stack.func_77978_p().func_74775_l(TAG_POS));
    }

    @Nullable
    public static BlockPos getPos(ItemStack stack, int compassDimension, int worldDimension) {
        BlockPos pos = ItemWaypointCompass.getPos(stack);
        if (pos == null) {
            return null;
        }
        if (compassDimension != worldDimension) {
            if (!Config.waypointCompassCrossDimension) {
                return null;
            }
            if (compassDimension == DimensionType.NETHER.func_186068_a()) {
                return new BlockPos(pos.func_177958_n() * 8, pos.func_177956_o(), pos.func_177952_p() * 8);
            }
            if (worldDimension == DimensionType.NETHER.func_186068_a()) {
                return new BlockPos(Math.round((float)pos.func_177958_n() / 8.0f), pos.func_177956_o(), Math.round((float)pos.func_177952_p() / 8.0f));
            }
        }
        return pos;
    }

    public static void setNBT(@Nonnull ItemStack stack, @Nullable World world, @Nullable BlockPos pos) {
        if (world == null || pos == null) {
            ItemWaypointCompass.clearNBT(stack);
            return;
        }
        ItemWaypointCompass.setNBT(stack, world.field_73011_w.getDimension(), pos);
    }

    private static void clearNBT(ItemStack stack) {
        if (stack.func_82837_s()) {
            String name = stack.func_82833_r();
            stack.func_77982_d(null);
            stack.func_151001_c(name);
        } else {
            stack.func_77982_d(null);
        }
    }

    public static void copyNBT(@Nonnull ItemStack stack, @Nonnull ItemStack waypoint) {
        if (!waypoint.func_77942_o()) {
            return;
        }
        ItemWaypointCompass.setNBT(stack, ItemWaypointCompass.getDimension(waypoint), ItemWaypointCompass.getPos(waypoint));
    }

    private static void setNBT(@Nonnull ItemStack stack, int dimension, BlockPos pos) {
        if (pos == null) {
            stack.func_77982_d(null);
            return;
        }
        NBTTagCompound tags = TagUtil.getTagSafe(stack);
        tags.func_74768_a(TAG_DIMENSION, dimension);
        tags.func_74782_a(TAG_POS, (NBTBase)TagUtil.writePos(pos));
        stack.func_77982_d(tags);
    }

    public static int getNeedleColor(EnumDyeColor color) {
        switch (color) {
            case WHITE: {
                return 16761088;
            }
            case SILVER: {
                return EnumDyeColor.WHITE.field_193351_w;
            }
            case GRAY: {
                return EnumDyeColor.SILVER.field_193351_w;
            }
            case BLACK: {
                return EnumDyeColor.RED.field_193351_w;
            }
            case RED: {
                return EnumDyeColor.ORANGE.field_193351_w;
            }
            case ORANGE: {
                return EnumDyeColor.YELLOW.field_193351_w;
            }
            case YELLOW: {
                return 14393875;
            }
            case LIME: {
                return EnumDyeColor.BROWN.field_193351_w;
            }
            case GREEN: {
                return EnumDyeColor.LIME.field_193351_w;
            }
            case CYAN: {
                return EnumDyeColor.LIGHT_BLUE.field_193351_w;
            }
            case LIGHT_BLUE: {
                return 7842303;
            }
            case BLUE: {
                return 8279295;
            }
            case PURPLE: {
                return EnumDyeColor.MAGENTA.field_193351_w;
            }
            case MAGENTA: {
                return EnumDyeColor.PINK.field_193351_w;
            }
            case PINK: {
                return 15908814;
            }
            case BROWN: {
                return 10850418;
            }
        }
        return -1;
    }

    public static boolean isWaypointCompass(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == InspirationsTools.waypointCompass || !Config.craftWaypointCompass && item == Items.field_151111_aL;
    }
}

